% Using MatLab
% Jeffrey N. Denenberg
% December 4, 1998

fprintf('\nThe MatLab Language\n')
pause
fprintf('\n    General\n')
fprintf('\n        Comments\n')
pause
fprintf('\n        Result Control\n')
fprintf('            "x=5"\n')
x=5
fprintf('            "x=7;"\n')
x=7;
pause
fprintf('            "x"\n')
x
pause
fprintf('\n        Range Operator\n')
fprintf('            "x=3:2:13"\n')
x=3:2:13
pause
fprintf('\n        Line Continuation - three periods\n')
pause
fprintf('\n        Directory\n')
fprintf('            "dir"\n')
dir
pause
fprintf('\n        Print Working Directory\n')
fprintf('            "pwd"\n')
pwd
pause
fprintf('\n        Change Directory - cd\n')
fprintf('            "cd .."\n')
cd ..
fprintf('            "pwd"\n')
pwd
fprintf('            "cd matlab"\n')
cd matlab
fprintf('            "pwd"\n')
pwd
pause
fprintf('\n    Scalars, Vectors, and Matrices\n')
fprintf('\n        Creating a row vector\n')
fprintf('            "X=[1,2,3] or X=[1 2 3]\n')
X=[1 2 3]
fprintf('\n        Creating a column vector\n')
fprintf('            "Y=[1;2;3]" or\n')
fprintf('            "Y=[1\n')
fprintf('               2\n')
fprintf('               3]"\n')
Y=[1;2;3]
pause
fprintf('            "Z=[y,2*y,3*y]" creates ?\n')
pause
Z=[Y,2*Y,3*Y]
fprintf('\n        Indexing\n')
fprintf('\n            "Z(2,3)=?"\n')
pause
Z(2,3)
pause
fprintf('\n            "W=Z(1:2,2:3)"\n')
W=Z(1:2,2:3)
pause
fprintf('\n            "W=Z(:,2)"\n')
W=Z(:,2)
pause
fprintf('\n            "W=Z(2,:)"\n')
W=Z(2,:)
pause
fprintf('\n            "Z(2,:)=[6,4,2] does ?"\n')
pause
Z(2,:)=[6,4,2];
Z
pause
fprintf('\n            "Z(2,:)=[ ] does ?"\n')
pause
Z(2,:)=[];
Z
pause
fprintf('\n        Matrix Operations\n')
fprintf('\n            A+B  - Addition, element by element\n')
fprintf('\n                "ZZ=[1,1,1;2,2,2]"\n')
ZZ=[1,1,1;2,2,2]
fprintf('\n                "W=Z+ZZ"\n')
W=Z+ZZ
pause
fprintf('\n            A''   - Transpose\n')
pause
fprintf('\n            A*B  - Matrix Multiplication\n')
fprintf('\n                "ZZ=ZZ'' "\n')
ZZ=ZZ'
fprintf('\n                "W=Z*ZZ"\n')
W=Z*ZZ
pause
fprintf('\n            A.*B - Element by Element Multiply\n')
pause
fprintf('\n            Also: A/B, A\\B, A./B, A.^2\n')
pause
fprintf('\n    Reserved Symbols\n')
fprintf('\n        Scalars: pi, i, j, inf, NaN, clock, date, ans\n')
pause
fprintf('\n            "x=pi"\n')
x=pi
pause
fprintf('\n            "x=i"\n')
x=i
pause
fprintf('\n            "x=j"\n')
x=j
pause
fprintf('\n        Matrices: zeros, ones, eye\n')
fprintf('\n            "zeros(3,5)"\n')
zeros(3,5)
pause
fprintf('\n            "ones(5,3)"\n')
ones(5,3)
pause
fprintf('\n            "eye(4)" - the identity matrix\n')
eye(4)
pause
fprintf('\n    Relational Operators\n')
fprintf('\n        "<"  - less than\n')
pause
fprintf('\n        "<=" - less than or equal to\n')
pause
fprintf('\n        ">"  - greater than\n')
pause
fprintf('\n        ">=" - greater than or equal to\n')
pause
fprintf('\n        "==" - test for equality\n')
pause
fprintf('\n        "~=" - not equal to\n')
pause
fprintf('\n        "&"  - AND\n')
pause
fprintf('\n        "|"  - OR\n')
pause
fprintf('\n        "~"  - NOT\n')
pause
fprintf('\n    Control Flow\n')
pause
fprintf('\n        "if x>5 & x<8"\n')
fprintf('            -------\n')
fprintf('            -------\n')
fprintf('         "elseif(x>=8)"\n')
fprintf('            -------\n')
fprintf('            -------\n')
fprintf('            else\n') % what's left
fprintf('            -------\n')
fprintf('            end\n')
pause
fprintf('\n        "for k=7:21"\n')
fprintf('            -------\n')
fprintf('            -------\n')
fprintf('            end\n')
pause
fprintf('\n        k=1;\n')
fprintf('        "while k=<10"\n')
fprintf('            -------\n')
fprintf('            -------\n')
fprintf('            k=k+1;\n')
fprintf('            end\n')
